﻿Public Class Form1

    Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As UInt32

    Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Public m_nDisplayTabNumber As UInt32 '0 = LIVE / 1 = RECORD PLAYBACK / 2 = MAIN REALTIME PLAYBACK / 3 = SUB REALTIME PLAYBACK

    Public m_nDeviceSerialNumber As UInt32 'DEVICE SERIAL NUMBER

    Public m_hVideoDev(0 To 3) As UInt32 'VIDEO STREAM CAPTURE DEVICE

    Public m_hVideoMainEncoderDev(0 To 3) As UInt32 'H.264 MAIN.STREAM CAPTURE DEVICE

    Public m_hVideoSubEncoderDev(0 To 3) As UInt32 'H.264 SUB.STREAM CAPTURE DEVICE

    Public m_hAudioDev(0 To 3) As UInt32 'AUDIO STREAM CAPTURE DEVICE

    Public m_hFileRendererDev(0 To 3) As UInt32 'FILE RENDERER DEVICE

    Public m_nFileRendererRecordState(0 To 3) As UInt32 '0 = STOP / 1 = ACQUIRE / 2 = START

    Public m_bFileRendererChangeNotify(0 To 3) As Boolean 'FILE.CHANGING.EVENT NOTIFY (0 = NONE / 1 = CHANGE)

    Public m_sFileRendererChangeSystemTime(0 To 3) As DateTime 'FILE.CHANGING.EVENT SYSTEM TIME

    Public m_pFileRendererChangeDevName(0 To 3) As String 'FILE.CHANGING.EVENT DEVICE NAME

    Public m_oFileRendererChangeMoniterLock(0 To 3) As Object 'FILE.CHANGING.EVENT CRITICAL SECTION

    Public m_hFileSourceDev(0 To 3) As UInt32 'FILE SOURCE DEVICE

    Public m_hNetworkRendererDev As UInt32 'NETWORK RENDERER DEVICE

    Public m_nNetworkRendererStreamingState(0 To 3) As UInt32 '0 = STOP / 1 = ACQUIRE / 2 = START

    Public m_pVideoBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_pVideoMainEncoderBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_pVideoSubEncoderBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_pAudioBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_cChannelControl_LIVE(0 To 3) As MyChannelControl 'LIVE STREAM DISPLAY WINDOW

    Public m_cChannelControl_FILE(0 To 3) As MyChannelControl 'FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)

    Public m_cChannelControl_H264_MAIN(0 To 3) As MyChannelControl 'H.264 MAIN.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

    Public m_cChannelControl_H264_SUB(0 To 3) As MyChannelControl 'H.264 SUB.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

    Public m_cSetupControl As MySetupControl

    Public m_cPropertyDlg As MyPeopertyDlg

    Public Function on_process_video_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hVideoDev As UInt32 = m_hVideoDev(i)

        Dim bIsVisible As UInt32 = 0

        Dim nLock As UInt32 = 0

        Dim nFps As UInt32 = 0

        AMESDK.NET.EXPORTS.AMESDK_GET_LOCK(hVideoDev, nLock)

        AMESDK.NET.EXPORTS.AMESDK_GET_FPS(hVideoDev, nFps)

        nLock = (nLock \ (2 ^ i)) And &H1

        'Debug.Print("CH" & i & ": LOCK = " & nLock & ", FPS =" & nFps) 'FOR DEBUG ONLY

        'AMESDK.NET.EXPORTS.AMESDK_OTHER_SNAPSHOT_JPG_EX(m_hVideoDev(i), "C:\SC2A0\CH" & (i + 1).ToString("D2") & "\TEMP.JPG", &H32315659, 1920, 1080, 12, 100) 'YV12 = &H32315659

        If m_nDisplayTabNumber = 0 Then bIsVisible = 1

        Return bIsVisible '1 = DISPLAY ON WINDOW

    End Function

    ' MAIN ENCODE STREAMING FOR FILE RECORDING
    '
    Public Function on_process_video_main_encoder_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hVideoEncoderDev As UInt32 = m_hVideoMainEncoderDev(i)

        Dim hFileRendererDev As UInt32 = m_hFileRendererDev(i)

        Dim bIsRecord As Boolean = (m_nFileRendererRecordState(i) = 2)

        Dim bIsVisible As UInt32 = 0

        If bIsKeyFrame Then

            If m_nFileRendererRecordState(i) = 1 Then

                ' WAITING KEY FRAME
                '
                m_nFileRendererRecordState(i) = 2 ' TO GOTO START STATE

                bIsRecord = True

            End If

            ' AUTO FILE SEGMENT (ON.TIMEOUT.EVENT)
            '
            Dim system_time As DateTime = DateTime.Now

            If (m_sFileRendererChangeSystemTime(i).Minute < 30 And system_time.Minute >= 30) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Minute >= 30 And system_time.Minute < 30) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Hour <> system_time.Hour) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Day <> system_time.Day) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Month <> system_time.Month) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Year <> system_time.Year) Then

                m_sFileRendererChangeSystemTime(i) = system_time

                m_pFileRendererChangeDevName(i) = "Common Analog File Renderer C:\SC2A0\CH" & (i + 1).ToString("D2") & "\" & _
                                                                                              system_time.Year.ToString("D4") & _
                                                                                              system_time.Month.ToString("D2") & _
                                                                                              system_time.Day.ToString("D2") & _
                                                                                              system_time.Hour.ToString("D2") & _
                                                                                              system_time.Minute.ToString("D2") & _
                                                                                              system_time.Second.ToString("D2") & ".MP4"

                System.Threading.Thread.VolatileWrite(m_bFileRendererChangeNotify(i), True)

            End If

            ' CHANGE CURRENT RECORD FILE (ON.FILE.CHANGE.EVENT)
            '
            If System.Threading.Thread.VolatileRead(m_bFileRendererChangeNotify(i)) Then

                Dim n_video_color_space_type As UInt32 = 0

                Dim n_video_frame_width As UInt32 = 0

                Dim n_video_frame_height As UInt32 = 0

                Dim n_video_frame_bit_count As UInt32 = 0

                Dim n_video_fps As Double = 0.0

                Dim n_video_custom_flags As UInt32 = 0

                Dim n_audio_steam_type As UInt32 = 0

                Dim n_audio_channels As UInt32 = 0

                Dim n_audio_bit_per_samlpe As UInt32 = 0

                Dim n_audio_samples_per_sec As UInt32 = 0

                Dim nDevType As UInteger = 3

                Dim nDisplayWindow As UInteger = 0

                Dim nUserData As UInteger = 0

                System.Threading.Monitor.Enter(m_oFileRendererChangeMoniterLock(i))

                ' CLOSE CURRENT RECORD FILE
                '
                If (m_hFileRendererDev(i) And &H80000000) = &H0 Then

                    AMESDK.NET.EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_FORMAT(m_hFileRendererDev(i), n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, n_video_fps, n_video_custom_flags)

                    AMESDK.NET.EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_FORMAT(m_hFileRendererDev(i), n_audio_steam_type, n_audio_channels, n_audio_bit_per_samlpe, n_audio_samples_per_sec)

                    AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hFileRendererDev(i))

                    m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

                End If

                ' UPDATE CURRENT FILE INFO LIST
                '
                Dim hWnd As Long = FindWindow(vbNullString, "Yuan's SC2A0N4 Live + H.264 Dual Stream Demo Software")

                PostMessage(hWnd, &H400, i, 0)

                ' CREATE NEW RECORD FILE
                '
                m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(m_pFileRendererChangeDevName(i), i, nDevType, nDisplayWindow, Nothing, nUserData)

                If (m_hFileRendererDev(i) And &H80000000) = &H80000000 Then m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

                AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev(i), n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, n_video_fps, n_video_custom_flags)

                AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev(i), n_audio_steam_type, n_audio_channels, n_audio_bit_per_samlpe, n_audio_samples_per_sec)

                System.Threading.Monitor.Exit(m_oFileRendererChangeMoniterLock(i))

                System.Threading.Thread.VolatileWrite(m_bFileRendererChangeNotify(i), False)

            End If

        End If

        If bIsRecord Then

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_BUFFER(hFileRendererDev, pBuffer, nBufferLen, bIsKeyFrame, 0, 0, Nothing, Nothing, Nothing, Nothing)

        End If

        If m_nDisplayTabNumber = 2 Then bIsVisible = 1

        Return bIsVisible '1 = DISPLAY ON WINDOW

    End Function

    ' SUB ENCODE STREAMING FOR NETWORK TRANSMISSION
    '
    Public Function on_process_video_sub_encoder_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hVideoEncoderDev As UInt32 = m_hVideoSubEncoderDev(i)

        Dim hNetworkRendererDev As UInt32 = m_hNetworkRendererDev

        Dim bIsStreaming As Boolean = (m_nNetworkRendererStreamingState(i) = 2)

        Dim bIsVisible As UInt32 = 0

        If bIsKeyFrame Then

            If m_nNetworkRendererStreamingState(i) = 1 Then

                ' WAITING KEY FRAME
                '
                m_nNetworkRendererStreamingState(i) = 2 'TO GOTO START STATE

                bIsStreaming = True

            End If

        End If

        If bIsStreaming Then

            'CHECK CURRENT CONNECTION STATUS OF NETWORK
            '
            Dim n_buffer_queue_size As UInt32 = 0

            Dim n_frame_queue_size As UInt32 = 0

            Dim n_clients As UInt32 = 0

            AMESDK.NET.EXPORTS.AMESDK_NETWORK_GET_VIDEO_STREAM_STATISTICS(m_hNetworkRendererDev, i, n_buffer_queue_size, n_frame_queue_size, n_clients) ' RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

            ' PUSH ONE VIDEO STREAM BUFFER INTO NETWORK
            '
            AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER(hNetworkRendererDev, i, pBuffer, nBufferLen, bIsKeyFrame, 0, 0)

        End If

        If m_nDisplayTabNumber = 3 Then bIsVisible = 1

        Return bIsVisible '1 = DISPLAY ON WINDOW

    End Function

    Public Function on_process_audio_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hAudioDev As UInt32 = m_hAudioDev(i)

        Dim hFileRendererDev As UInt32 = m_hFileRendererDev(i)

        Dim hNetworkRendererDev As UInt32 = m_hNetworkRendererDev

        Dim bIsRecord As Boolean = (m_nFileRendererRecordState(i) = 2)

        Dim bIsStreaming As Boolean = (m_nNetworkRendererStreamingState(i) = 2)

        Dim bIsMute As UInt32 = 0

        If bIsRecord Then

            System.Threading.Monitor.Enter(m_oFileRendererChangeMoniterLock(i))

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_BUFFER(m_hFileRendererDev(i), pBuffer, nBufferLen, 0, 0, Nothing)

            System.Threading.Monitor.Exit(m_oFileRendererChangeMoniterLock(i))

        End If

        If bIsStreaming Then

            ' CHECK CURRENT CONNECTION STATUS OF NETWORK
            '
            Dim n_buffer_queue_size As UInt32 = 0

            Dim n_frame_queue_size As UInt32 = 0

            Dim n_clients As UInt32 = 0

            AMESDK.NET.EXPORTS.AMESDK_NETWORK_GET_AUDIO_STREAM_STATISTICS(hNetworkRendererDev, i, n_buffer_queue_size, n_frame_queue_size, n_clients) ' RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

            ' PUSH ONE AUDIO STREAM BUFFER INTO NETWORK
            '
            AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER(hNetworkRendererDev, i, pBuffer, nBufferLen, 0, 0)

        End If

        If m_nDisplayTabNumber = 0 Then bIsMute = 1

        If m_nDisplayTabNumber = 2 Then bIsMute = 1

        Return bIsMute

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim i As UInt32 = 0

        'USER INTERFACE PROGRAMMING (MAIN FORM)
        '
        Dim BorderSize As System.Drawing.Size = Me.Size - Me.ClientSize

        Me.Width = BorderSize.Width + 704

        Me.Height = BorderSize.Height + 480

        For i = 0 To 3

            m_cChannelControl_LIVE(i) = New MyChannelControl()
            m_cChannelControl_FILE(i) = New MyChannelControl()
            m_cChannelControl_H264_MAIN(i) = New MyChannelControl()
            m_cChannelControl_H264_SUB(i) = New MyChannelControl()

            m_cChannelControl_LIVE(i).Parent = Me
            m_cChannelControl_FILE(i).Parent = Me
            m_cChannelControl_H264_MAIN(i).Parent = Me
            m_cChannelControl_H264_SUB(i).Parent = Me

            If i = 0 Then m_cChannelControl_LIVE(i).Left = 0
            If i = 0 Then m_cChannelControl_FILE(i).Left = 0
            If i = 0 Then m_cChannelControl_H264_MAIN(i).Left = 0
            If i = 0 Then m_cChannelControl_H264_SUB(i).Left = 0

            If i = 1 Then m_cChannelControl_LIVE(i).Left = 352
            If i = 1 Then m_cChannelControl_FILE(i).Left = 352
            If i = 1 Then m_cChannelControl_H264_MAIN(i).Left = 352
            If i = 1 Then m_cChannelControl_H264_SUB(i).Left = 352

            If i = 2 Then m_cChannelControl_LIVE(i).Left = 0
            If i = 2 Then m_cChannelControl_FILE(i).Left = 0
            If i = 2 Then m_cChannelControl_H264_MAIN(i).Left = 0
            If i = 2 Then m_cChannelControl_H264_SUB(i).Left = 0

            If i = 3 Then m_cChannelControl_LIVE(i).Left = 352
            If i = 3 Then m_cChannelControl_FILE(i).Left = 352
            If i = 3 Then m_cChannelControl_H264_MAIN(i).Left = 352
            If i = 3 Then m_cChannelControl_H264_SUB(i).Left = 352

            If i = 0 Then m_cChannelControl_LIVE(i).Top = 0
            If i = 0 Then m_cChannelControl_FILE(i).Top = 0
            If i = 0 Then m_cChannelControl_H264_MAIN(i).Top = 0
            If i = 0 Then m_cChannelControl_H264_SUB(i).Top = 0

            If i = 1 Then m_cChannelControl_LIVE(i).Top = 0
            If i = 1 Then m_cChannelControl_FILE(i).Top = 0
            If i = 1 Then m_cChannelControl_H264_MAIN(i).Top = 0
            If i = 1 Then m_cChannelControl_H264_SUB(i).Top = 0

            If i = 2 Then m_cChannelControl_LIVE(i).Top = 240
            If i = 2 Then m_cChannelControl_FILE(i).Top = 240
            If i = 2 Then m_cChannelControl_H264_MAIN(i).Top = 240
            If i = 2 Then m_cChannelControl_H264_SUB(i).Top = 240

            If i = 3 Then m_cChannelControl_LIVE(i).Top = 240
            If i = 3 Then m_cChannelControl_FILE(i).Top = 240
            If i = 3 Then m_cChannelControl_H264_MAIN(i).Top = 240
            If i = 3 Then m_cChannelControl_H264_SUB(i).Top = 240

            m_cChannelControl_LIVE(i).Size = New System.Drawing.Size(352, 240)
            m_cChannelControl_FILE(i).Size = New System.Drawing.Size(352, 240)
            m_cChannelControl_H264_MAIN(i).Size = New System.Drawing.Size(352, 240)
            m_cChannelControl_H264_SUB(i).Size = New System.Drawing.Size(352, 240)

            m_cChannelControl_LIVE(i).Visible = True
            m_cChannelControl_FILE(i).Visible = False
            m_cChannelControl_H264_MAIN(i).Visible = False
            m_cChannelControl_H264_SUB(i).Visible = False

            m_cChannelControl_LIVE(i).m_nChannelNumber = i + &H1000000
            m_cChannelControl_FILE(i).m_nChannelNumber = i + &H2000000
            m_cChannelControl_H264_MAIN(i).m_nChannelNumber = i + &H4000000
            m_cChannelControl_H264_SUB(i).m_nChannelNumber = i + &H8000000

        Next

        For i = 0 To 3

            m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hVideoMainEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hVideoSubEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_nFileRendererRecordState(i) = 0

            System.Threading.Thread.VolatileWrite(m_bFileRendererChangeNotify(i), False)

            m_sFileRendererChangeSystemTime(i) = DateTime.Now

            m_pFileRendererChangeDevName(i) = ""

            m_hFileSourceDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

            m_nNetworkRendererStreamingState(i) = 0

        Next

        m_pVideoBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_video_buffer)

        m_pVideoMainEncoderBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_video_main_encoder_buffer)

        m_pVideoSubEncoderBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_video_sub_encoder_buffer)

        m_pAudioBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_audio_buffer)

        m_oFileRendererChangeMoniterLock(0) = New Object

        m_oFileRendererChangeMoniterLock(1) = New Object

        m_oFileRendererChangeMoniterLock(2) = New Object

        m_oFileRendererChangeMoniterLock(3) = New Object

        m_nDisplayTabNumber = 0

        'USER INTERFACE PROGRAMMING (SETUP CONTROL)
        '
        m_cSetupControl = New MySetupControl()

        m_cPropertyDlg = New MyPeopertyDlg()

        m_cSetupControl.m_pMainForm = Me

        m_cPropertyDlg.m_pMainForm = Me

        BorderSize = m_cSetupControl.Size - m_cSetupControl.ClientSize

        Me.Top = Me.Top - 75

        m_cSetupControl.Top = Me.Bottom + 5

        m_cSetupControl.Left = Me.Left - ((1248 - 704 - BorderSize.Width) / 2)

        m_cSetupControl.Width = 0

        m_cSetupControl.Height = 0

        m_cSetupControl.Visible = False

        m_cSetupControl.Show()

        m_cSetupControl.Visible = False

        HwInitialize()

        m_cSetupControl.Width = BorderSize.Width + 1248

        m_cSetupControl.Height = BorderSize.Height + 25 * 12

        m_cSetupControl.Visible = True

    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        HwUninitialize()

        m_cSetupControl.Close()

    End Sub

    Public Function HwInitialize() As Boolean

        'GET DEVICE PARAMETERS FROM SETUP DIALOG
        '
        Dim std As UInt32

        Dim cx(0 To 7) As UInt32

        Dim cy(0 To 7) As UInt32

        Dim fps(0 To 7) As Double

        Dim deinterlace(0 To 7) As UInt32

        Dim rcmode(0 To 7) As UInt32

        Dim bitrate(0 To 7) As UInt32

        Dim quality(0 To 7) As UInt32

        Dim gop(0 To 7) As UInt32

        Dim qpstep(0 To 7) As UInt32

        Dim peakbitrate(0 To 7) As UInt32

        Dim troughquality(0 To 7) As UInt32

        Dim i As UInt32

        Dim nDevNum As UInteger = 0

        Dim nDevType As UInteger = 5

        Dim nDisplayWindow As UInteger = 0

        Dim nUserData As UInteger = 0

        m_cSetupControl.GetStandardParameter(std)

        m_cSetupControl.GetResolutionParameter(cx, cy)

        m_cSetupControl.GetFrameRateParameter(fps)

        m_cSetupControl.GetDeinterlaceParameter(deinterlace)

        m_cSetupControl.GetRecordModeParameter(rcmode)

        m_cSetupControl.GetBitRateParameter(bitrate)

        m_cSetupControl.GetQualityParameter(quality)

        m_cSetupControl.GetGOPParameter(gop)

        m_cSetupControl.GetQPStepParameter(qpstep)

        m_cSetupControl.GetPeakBitRateParameter(peakbitrate)

        m_cSetupControl.GetTroughQualityParameter(troughquality)

        'INITIALIZE NETWORK RENDERERS (RTSP)
        '
        m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

        m_hNetworkRendererDev = AMESDK.NET.EXPORTS.AMESDK_CREATE("Common Analog Network Renderer streams=4", nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

        If (m_hNetworkRendererDev And &H80000000) = &H80000000 Then m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 0, &H34363248, cx(4), cy(4), 24, fps(4), bitrate(4) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 1, &H34363248, cx(5), cy(5), 24, fps(5), bitrate(5) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 2, &H34363248, cx(6), cy(6), 24, fps(6), bitrate(6) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 3, &H34363248, cx(7), cy(7), 24, fps(7), bitrate(7) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0, 1, 16, 16000, 1 * 16 * 16000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0, 1, 16, 16000, 1 * 16 * 16000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0, 1, 16, 16000, 1 * 16 * 16000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0, 1, 16, 16000, 1 * 16 * 16000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_USER_ACCOUNT(m_hNetworkRendererDev, "root", "root")

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_STREAMING_PORT(m_hNetworkRendererDev, 554)

        'INITIALIZE FILE RENDERERS
        '
        For i = 0 To 3

            Dim system_time As DateTime = DateTime.Now

            Dim file_path As String

            m_sFileRendererChangeSystemTime(i) = system_time

            file_path = "Common Analog File Renderer C:\SC2A0\CH" & (i + 1).ToString("D2") & "\" & _
                                                                    system_time.Year.ToString("D4") & _
                                                                    system_time.Month.ToString("D2") & _
                                                                    system_time.Day.ToString("D2") & _
                                                                    system_time.Hour.ToString("D2") & _
                                                                    system_time.Minute.ToString("D2") & _
                                                                    system_time.Second.ToString("D2") & ".MP4"

            m_pFileRendererChangeDevName(i) = file_path

            m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            nDevType = 3

            If i = 0 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If i = 1 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If i = 2 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If i = 3 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If (m_hFileRendererDev(i) And &H80000000) = &H80000000 Then m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            Dim custom_flags As UInt32 = &H0

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev(i), &H34363248, cx(i), cy(i), 24, fps(i), custom_flags) 'H264 = &H34363248

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev(i), 0, 1, 16, 16000)

        Next

        'INITIALIZE VIDEO STREAMS (YV12)
        '
        For i = 0 To 3

            m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            nDevType = 0

            If i = 0 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI", i, nDevType, CType(m_cChannelControl_LIVE(0).Handle, UInteger), m_pVideoBufferCB, i)

            If i = 1 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI", i, nDevType, CType(m_cChannelControl_LIVE(1).Handle, UInteger), m_pVideoBufferCB, i)

            If i = 2 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI", i, nDevType, CType(m_cChannelControl_LIVE(2).Handle, UInteger), m_pVideoBufferCB, i)

            If i = 3 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI", i, nDevType, CType(m_cChannelControl_LIVE(3).Handle, UInteger), m_pVideoBufferCB, i)

            If (m_hVideoDev(i) And &H80000000) = &H80000000 Then m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If std And &H1 Then

                AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev(i), &H1) 'NTSC = &H00000001

                AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev(i), &H32315659, 704, 480, 12, 29.97) 'YV12 = &H32315659

                AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev(i), 0)

            Else

                AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev(i), &H10) 'PAL = &H00000010

                AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev(i), &H32315659, 704, 576, 12, 25.0) 'YV12 = &H32315659

                AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev(i), 0)

            End If

            If i = 0 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 0, 0)

            If i = 1 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 0, 0)

            If i = 2 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 1, 0)

            If i = 3 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 1, 0)

            Dim n_device_serial_number As UInt32 = 0

            Dim n_video_standard As UInt32 = 0

            Dim n_video_colorspace As UInt32 = 0

            Dim n_video_width As UInt32 = 0

            Dim n_video_height As UInt32 = 0

            Dim n_video_bitcount As UInt32 = 0

            Dim d_video_framerate As Double = 0

            Dim n_video_deinterlace As UInt32 = 0

            Dim n_video_horizontal_mirror As UInt32 = 0

            Dim n_video_vertical_mirror As UInt32 = 0

            AMESDK.NET.EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev(i), 0, n_device_serial_number)

            AMESDK.NET.EXPORTS.AMESDK_GET_STANDARD(m_hVideoDev(i), n_video_standard)

            AMESDK.NET.EXPORTS.AMESDK_GET_FORMAT(m_hVideoDev(i), n_video_colorspace, n_video_width, n_video_height, n_video_bitcount, d_video_framerate)

            AMESDK.NET.EXPORTS.AMESDK_GET_DEINTERLACE(m_hVideoDev(i), n_video_deinterlace)

            AMESDK.NET.EXPORTS.AMESDK_GET_MIRROR(m_hVideoDev(i), n_video_horizontal_mirror, n_video_vertical_mirror)

        Next

        nDevType = 0

        'INITIALIZE VIDEO MAIN ENCODER STREAMS (H.264)
        '
        For i = 0 To 3

            m_hVideoMainEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If i = 0 Then m_hVideoMainEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_MAIN(0).Handle, UInteger), m_pVideoMainEncoderBufferCB, i)

            If i = 1 Then m_hVideoMainEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_MAIN(1).Handle, UInteger), m_pVideoMainEncoderBufferCB, i)

            If i = 2 Then m_hVideoMainEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_MAIN(2).Handle, UInteger), m_pVideoMainEncoderBufferCB, i)

            If i = 3 Then m_hVideoMainEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_MAIN(3).Handle, UInteger), m_pVideoMainEncoderBufferCB, i)

            If (m_hVideoMainEncoderDev(i) And &H80000000) = &H80000000 Then m_hVideoMainEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoMainEncoderDev(i), std) 'NTSC = &H00000001 / PAL = &H00000010

            AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoMainEncoderDev(i), &H34363248, cx(i), cy(i), 24, fps(i)) 'H264 = &H34363248

            AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoMainEncoderDev(i), deinterlace(i)) 'DISABLE = &H00000000 / BEST = &H00000007

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 3, rcmode(i)) 'RECORD MODE

            If rcmode(i) = 0 Then 'VBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 1, quality(i)) 'QUALITY

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 0, gop(i)) 'GOP

            End If

            If rcmode(i) = 1 Then 'CBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 4, bitrate(i)) 'BITRATE

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 0, gop(i)) 'GOP

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 5, qpstep(i)) 'QPSTEP

            End If

            If rcmode(i) = 2 Then 'HBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 4, bitrate(i)) 'BITRATE

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 1, quality(i)) 'QUALITY

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 0, gop(i)) 'GOP

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 5, qpstep(i)) 'QPSTEP

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 6, peakbitrate(i)) 'PEAK BITRATE

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev(i), 7, troughquality(i)) 'TROUGH QUALITY

            End If

        Next

        nDevType = 0

        'INITIALIZE VIDEO SUB ENCODER STREAMS (H.264)
        '
        For i = 0 To 3

            m_hVideoSubEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If i = 0 Then m_hVideoSubEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_SUB(0).Handle, UInteger), m_pVideoSubEncoderBufferCB, i)

            If i = 1 Then m_hVideoSubEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_SUB(1).Handle, UInteger), m_pVideoSubEncoderBufferCB, i)

            If i = 2 Then m_hVideoSubEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_SUB(2).Handle, UInteger), m_pVideoSubEncoderBufferCB, i)

            If i = 3 Then m_hVideoSubEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264_SUB(3).Handle, UInteger), m_pVideoSubEncoderBufferCB, i)

            If (m_hVideoSubEncoderDev(i) And &H80000000) = &H80000000 Then m_hVideoSubEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoSubEncoderDev(i), std) 'NTSC = &H00000001 / PAL = &H00000010

            AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoSubEncoderDev(i), &H34363258, cx(i + 4), cy(i + 4), 24, fps(i + 4)) 'X264 = &H34363258

            AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoSubEncoderDev(i), deinterlace(i + 4)) 'DISABLE = &H00000000 / BEST = &H00000007

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev(i), 3, rcmode(i + 4)) 'RECORD MODE

            If rcmode(i + 4) = 0 Then ' VBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev(i), 1, quality(i + 4)) ' QUALITY (VBR)

            End If

            If rcmode(i + 4) = 1 Then 'CBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev(i), 4, bitrate(i + 4)) ' BITRATE (CBR)

            End If

            If rcmode(i + 4) = 2 Then ' HBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev(i), 1, quality(i + 4)) ' QUALITY (HBR)

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev(i), 4, bitrate(i + 4)) ' BITRATE (HBR)

            End If

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev(i), 0, gop(i + 4)) 'GOP

        Next

        nDevType = 0

        nDisplayWindow = 0

        'INITIALIZE AUDIO STREAMS (PCM)
        '
        For i = 0 To 3

            m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If i = 0 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If i = 1 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If i = 2 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If i = 3 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("FH8735 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If (m_hAudioDev(i) And &H80000000) = &H80000000 Then m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            Dim n_audio_channels As UInt32 = 0

            Dim n_audio_bits_per_sample As UInt32 = 0

            Dim n_audio_samples_per_sec As UInt32 = 0

            AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hAudioDev(i), 1, 16, 16000) 'MONO / 16BITS / 16000HZ

            AMESDK.NET.EXPORTS.AMESDK_GET_FORMAT(m_hAudioDev(i), n_audio_channels, n_audio_bits_per_sample, n_audio_samples_per_sec)

        Next

        'SET CUSTOM OSD PROPERTY
        '
        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(0), 929, 0) 'SET OSD COLOR

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(1), 929, 2) 'SET OSD COLOR

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(2), 929, 4) 'SET OSD COLOR

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(3), 929, 5) 'SET OSD COLOR

        'SET OSD FILE PATH
        '
        Dim OSD_PATH() As Byte = New Byte(0 To 10) {Asc("D"), Asc(":"), Asc("\"), Asc("O"), Asc("S"), Asc("D"), Asc("."), Asc("T"), Asc("X"), Asc("T"), 0}

        Dim NONE_OSD_PATH() As Byte = New Byte(0 To 13) {Asc("D"), Asc(":"), Asc("\"), Asc("N"), Asc("O"), Asc("N"), Asc("O"), Asc("S"), Asc("D"), Asc("."), Asc("T"), Asc("X"), Asc("T"), 0}

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(0), 920, 0) ' SET OSD LINE

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoMainEncoderDev(0), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD_PATH(0)), 10 + 1) 'SET OSD TEXT

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(1), 920, 0) ' SET OSD LINE

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoMainEncoderDev(1), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD_PATH(0)), 10 + 1) 'SET OSD TEXT

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(2), 920, 0) ' SET OSD LINE

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoMainEncoderDev(2), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD_PATH(0)), 10 + 1) 'SET OSD TEXT

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoMainEncoderDev(3), 920, 0) ' SET OSD LINE

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoMainEncoderDev(3), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD_PATH(0)), 10 + 1) 'SET OSD TEXT

        'GET DEVICE SERIAL NUMBER
        '  
        AMESDK.NET.EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev(0), 0, m_nDeviceSerialNumber)

        ' DEVICE RUN
        '
        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hNetworkRendererDev)

        System.Threading.Thread.Sleep(512)

        ' STRAT RECORDING
        '
        m_bFileRendererChangeNotify(0) = False

        m_bFileRendererChangeNotify(1) = False

        m_bFileRendererChangeNotify(2) = False

        m_bFileRendererChangeNotify(3) = False

        m_nFileRendererRecordState(0) = 1 'ACQUIRE RECORDING

        m_nFileRendererRecordState(1) = 1 'ACQUIRE RECORDING

        m_nFileRendererRecordState(2) = 1 'ACQUIRE RECORDING

        m_nFileRendererRecordState(3) = 1 'ACQUIRE RECORDING

        If (m_hVideoSubEncoderDev(0) <> 4294967295) Then '4294967295 = &HFFFFFFFF

            m_nNetworkRendererStreamingState(0) = 1 ' ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

        End If

        If (m_hVideoSubEncoderDev(1) <> 4294967295) Then '4294967295 = &HFFFFFFFF

            m_nNetworkRendererStreamingState(1) = 1 ' ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

        End If

        If (m_hVideoSubEncoderDev(2) <> 4294967295) Then '4294967295 = &HFFFFFFFF

            m_nNetworkRendererStreamingState(2) = 1 ' ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

        End If

        If (m_hVideoSubEncoderDev(3) <> 4294967295) Then '4294967295 = &HFFFFFFFF

            m_nNetworkRendererStreamingState(3) = 1 ' ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

        End If

        Return True

    End Function

    Public Function HwUninitialize() As Boolean

        m_nNetworkRendererStreamingState(0) = 0 'STOP STREAMING

        m_nNetworkRendererStreamingState(1) = 0 'STOP STREAMING

        m_nNetworkRendererStreamingState(2) = 0 'STOP STREAMING

        m_nNetworkRendererStreamingState(3) = 0 'STOP STREAMING

        m_nFileRendererRecordState(0) = 0 'STOP RECORDING

        m_nFileRendererRecordState(1) = 0 'STOP RECORDING

        m_nFileRendererRecordState(2) = 0 'STOP RECORDING

        m_nFileRendererRecordState(3) = 0 'STOP RECORDING

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(3))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev(3))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev(3))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(3))

        Dim i As UInt32 = 0

        For i = 0 To 3

            If (m_hVideoDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hVideoDev(i))

            If (m_hVideoMainEncoderDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hVideoMainEncoderDev(i))

            If (m_hVideoSubEncoderDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hVideoSubEncoderDev(i))

            If (m_hAudioDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hAudioDev(i))

            If (m_hFileRendererDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hFileRendererDev(i))

            m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hVideoMainEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hVideoSubEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

        Next

        AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hNetworkRendererDev)

        m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

        Return True

    End Function

    Public Sub OnLButtonDown_ChannelControl(ByVal nChannelNumber As UInt32)

        If nChannelNumber And &H1000000 Then 'LIVE PATH

            Dim i As UInt32 = nChannelNumber - &H1000000

            If m_cChannelControl_LIVE(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_LIVE(i).Left = 0
                If i = 1 Then m_cChannelControl_LIVE(i).Left = 352
                If i = 2 Then m_cChannelControl_LIVE(i).Left = 0
                If i = 3 Then m_cChannelControl_LIVE(i).Left = 352
                If i = 0 Then m_cChannelControl_LIVE(i).Top = 0
                If i = 1 Then m_cChannelControl_LIVE(i).Top = 0
                If i = 2 Then m_cChannelControl_LIVE(i).Top = 240
                If i = 3 Then m_cChannelControl_LIVE(i).Top = 240

                m_cChannelControl_LIVE(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_LIVE(0).Visible = True
                m_cChannelControl_LIVE(1).Visible = True
                m_cChannelControl_LIVE(2).Visible = True
                m_cChannelControl_LIVE(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev(i))

            Else

                m_cChannelControl_LIVE(i).Left = 0
                m_cChannelControl_LIVE(i).Top = 0
                m_cChannelControl_LIVE(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_LIVE(0).Visible = False
                m_cChannelControl_LIVE(1).Visible = False
                m_cChannelControl_LIVE(2).Visible = False
                m_cChannelControl_LIVE(3).Visible = False
                m_cChannelControl_LIVE(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev(i))

            End If

        End If

        If nChannelNumber And &H2000000 Then 'FILE STREAM PATH

            Dim i As UInt32 = nChannelNumber - &H2000000

            If m_cChannelControl_FILE(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_FILE(i).Left = 0
                If i = 1 Then m_cChannelControl_FILE(i).Left = 352
                If i = 2 Then m_cChannelControl_FILE(i).Left = 0
                If i = 3 Then m_cChannelControl_FILE(i).Left = 352

                If i = 0 Then m_cChannelControl_FILE(i).Top = 0
                If i = 1 Then m_cChannelControl_FILE(i).Top = 0
                If i = 2 Then m_cChannelControl_FILE(i).Top = 240
                If i = 3 Then m_cChannelControl_FILE(i).Top = 240

                m_cChannelControl_FILE(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_FILE(0).Visible = True
                m_cChannelControl_FILE(1).Visible = True
                m_cChannelControl_FILE(2).Visible = True
                m_cChannelControl_FILE(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev(i))

            Else

                m_cChannelControl_FILE(i).Left = 0
                m_cChannelControl_FILE(i).Top = 0
                m_cChannelControl_FILE(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_FILE(0).Visible = False
                m_cChannelControl_FILE(1).Visible = False
                m_cChannelControl_FILE(2).Visible = False
                m_cChannelControl_FILE(3).Visible = False
                m_cChannelControl_FILE(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev(i))

            End If

        End If

        If nChannelNumber And &H4000000 Then 'H.264 MAIN.STREAM PATH

            Dim i As UInt32 = nChannelNumber - &H4000000

            If m_cChannelControl_H264_MAIN(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_H264_MAIN(i).Left = 0
                If i = 1 Then m_cChannelControl_H264_MAIN(i).Left = 352
                If i = 2 Then m_cChannelControl_H264_MAIN(i).Left = 0
                If i = 3 Then m_cChannelControl_H264_MAIN(i).Left = 352

                If i = 0 Then m_cChannelControl_H264_MAIN(i).Top = 0
                If i = 1 Then m_cChannelControl_H264_MAIN(i).Top = 0
                If i = 2 Then m_cChannelControl_H264_MAIN(i).Top = 240
                If i = 3 Then m_cChannelControl_H264_MAIN(i).Top = 240

                m_cChannelControl_H264_MAIN(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_H264_MAIN(0).Visible = True
                m_cChannelControl_H264_MAIN(1).Visible = True
                m_cChannelControl_H264_MAIN(2).Visible = True
                m_cChannelControl_H264_MAIN(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoMainEncoderDev(i))

            Else

                m_cChannelControl_H264_MAIN(i).Left = 0
                m_cChannelControl_H264_MAIN(i).Top = 0
                m_cChannelControl_H264_MAIN(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_H264_MAIN(0).Visible = False
                m_cChannelControl_H264_MAIN(1).Visible = False
                m_cChannelControl_H264_MAIN(2).Visible = False
                m_cChannelControl_H264_MAIN(3).Visible = False
                m_cChannelControl_H264_MAIN(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoMainEncoderDev(i))

            End If

        End If

        If nChannelNumber And &H8000000 Then 'H.264 SUB.STREAM PATH

            Dim i As UInt32 = nChannelNumber - &H8000000

            If m_cChannelControl_H264_SUB(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_H264_SUB(i).Left = 0
                If i = 1 Then m_cChannelControl_H264_SUB(i).Left = 352
                If i = 2 Then m_cChannelControl_H264_SUB(i).Left = 0
                If i = 3 Then m_cChannelControl_H264_SUB(i).Left = 352

                If i = 0 Then m_cChannelControl_H264_SUB(i).Top = 0
                If i = 1 Then m_cChannelControl_H264_SUB(i).Top = 0
                If i = 2 Then m_cChannelControl_H264_SUB(i).Top = 240
                If i = 3 Then m_cChannelControl_H264_SUB(i).Top = 240

                m_cChannelControl_H264_SUB(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_H264_SUB(0).Visible = True
                m_cChannelControl_H264_SUB(1).Visible = True
                m_cChannelControl_H264_SUB(2).Visible = True
                m_cChannelControl_H264_SUB(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoSubEncoderDev(i))

            Else

                m_cChannelControl_H264_SUB(i).Left = 0
                m_cChannelControl_H264_SUB(i).Top = 0
                m_cChannelControl_H264_SUB(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_H264_SUB(0).Visible = False
                m_cChannelControl_H264_SUB(1).Visible = False
                m_cChannelControl_H264_SUB(2).Visible = False
                m_cChannelControl_H264_SUB(3).Visible = False
                m_cChannelControl_H264_SUB(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoSubEncoderDev(i))

            End If

        End If

    End Sub

    Public Sub OnCheckedChanged_RadioButton_SetupControl(ByVal nRadioButtonNumber As UInt32)

        If nRadioButtonNumber = 0 Then 'LIVE PATH

            m_nDisplayTabNumber = 0

            m_cChannelControl_LIVE(0).Visible = True
            m_cChannelControl_LIVE(1).Visible = True
            m_cChannelControl_LIVE(2).Visible = True
            m_cChannelControl_LIVE(3).Visible = True
            m_cChannelControl_FILE(0).Visible = False
            m_cChannelControl_FILE(1).Visible = False
            m_cChannelControl_FILE(2).Visible = False
            m_cChannelControl_FILE(3).Visible = False
            m_cChannelControl_H264_MAIN(0).Visible = False
            m_cChannelControl_H264_MAIN(1).Visible = False
            m_cChannelControl_H264_MAIN(2).Visible = False
            m_cChannelControl_H264_MAIN(3).Visible = False
            m_cChannelControl_H264_SUB(0).Visible = False
            m_cChannelControl_H264_SUB(1).Visible = False
            m_cChannelControl_H264_SUB(2).Visible = False
            m_cChannelControl_H264_SUB(3).Visible = False

        End If

        If nRadioButtonNumber = 1 Then 'FILE STREAM PATH

            m_nDisplayTabNumber = 1

            m_cChannelControl_FILE(0).Visible = True
            m_cChannelControl_FILE(1).Visible = True
            m_cChannelControl_FILE(2).Visible = True
            m_cChannelControl_FILE(3).Visible = True
            m_cChannelControl_LIVE(0).Visible = False
            m_cChannelControl_LIVE(1).Visible = False
            m_cChannelControl_LIVE(2).Visible = False
            m_cChannelControl_LIVE(3).Visible = False
            m_cChannelControl_H264_MAIN(0).Visible = False
            m_cChannelControl_H264_MAIN(1).Visible = False
            m_cChannelControl_H264_MAIN(2).Visible = False
            m_cChannelControl_H264_MAIN(3).Visible = False
            m_cChannelControl_H264_SUB(0).Visible = False
            m_cChannelControl_H264_SUB(1).Visible = False
            m_cChannelControl_H264_SUB(2).Visible = False
            m_cChannelControl_H264_SUB(3).Visible = False

        End If

        If nRadioButtonNumber = 2 Then 'H.264 MAIN.STREAM PATH

            m_nDisplayTabNumber = 2

            m_cChannelControl_H264_MAIN(0).Visible = True
            m_cChannelControl_H264_MAIN(1).Visible = True
            m_cChannelControl_H264_MAIN(2).Visible = True
            m_cChannelControl_H264_MAIN(3).Visible = True
            m_cChannelControl_LIVE(0).Visible = False
            m_cChannelControl_LIVE(1).Visible = False
            m_cChannelControl_LIVE(2).Visible = False
            m_cChannelControl_LIVE(3).Visible = False
            m_cChannelControl_FILE(0).Visible = False
            m_cChannelControl_FILE(1).Visible = False
            m_cChannelControl_FILE(2).Visible = False
            m_cChannelControl_FILE(3).Visible = False
            m_cChannelControl_H264_SUB(0).Visible = False
            m_cChannelControl_H264_SUB(1).Visible = False
            m_cChannelControl_H264_SUB(2).Visible = False
            m_cChannelControl_H264_SUB(3).Visible = False

        End If

        If nRadioButtonNumber = 3 Then 'H.264 SUB.STREAM PATH

            m_nDisplayTabNumber = 3

            m_cChannelControl_H264_SUB(0).Visible = True
            m_cChannelControl_H264_SUB(1).Visible = True
            m_cChannelControl_H264_SUB(2).Visible = True
            m_cChannelControl_H264_SUB(3).Visible = True
            m_cChannelControl_H264_MAIN(0).Visible = False
            m_cChannelControl_H264_MAIN(1).Visible = False
            m_cChannelControl_H264_MAIN(2).Visible = False
            m_cChannelControl_H264_MAIN(3).Visible = False
            m_cChannelControl_LIVE(0).Visible = False
            m_cChannelControl_LIVE(1).Visible = False
            m_cChannelControl_LIVE(2).Visible = False
            m_cChannelControl_LIVE(3).Visible = False
            m_cChannelControl_FILE(0).Visible = False
            m_cChannelControl_FILE(1).Visible = False
            m_cChannelControl_FILE(2).Visible = False
            m_cChannelControl_FILE(3).Visible = False

        End If

    End Sub

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)

        If m.Msg = &H14 Then '&H00000014 = WM_ERASEBKGND

            Return

        End If

        If m.Msg = &H400 Then '&H00000400 = WM_USER (UPDATE FILE INFO LIST)

            Dim system_time As DateTime = DateTime.Now

            Dim start_search_system_time As DateTime = New DateTime(system_time.Year, system_time.Month, system_time.Day)

            Dim stop_search_system_time As DateTime = New DateTime(system_time.Year, system_time.Month, system_time.Day, 23, 59, 59, 999)

            Dim n_start_search_systemtime As UInt64 = start_search_system_time.ToFileTimeUtc()

            Dim n_stop_search_systemtime As UInt64 = stop_search_system_time.ToFileTimeUtc()

            Dim i As UInt32 = m.WParam

            Dim psz_search_directory = "C:\SC2A0\CH" & (i + 1).ToString("D2") & "\"

            AMESDK.NET.EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_cSetupControl.m_cFileManagerControl.m_pFileInfoList(i), psz_search_directory, n_start_search_systemtime, n_stop_search_systemtime) '18446744073709551615 = &HFFFFFFFFFFFFFFFF

            m_cSetupControl.m_cFileManagerControl.Invalidate(True)

        End If

        MyBase.WndProc(m)

    End Sub


End Class
